/**
 * Astro Telemetry -- Project Info
 *
 * To better understand our telemetry insights, Astro attempts to create an anonymous identifier
 * for each Astro project. This value is meant to be unique to each project but common across
 * multiple different users on the same project.
 *
 * To do this, we generate a unique, anonymous hash from your working git repository data. This is
 * ideal because git data is shared across all users on the same repository, but the data itself
 * that we generate our hash from does not contain any personal or otherwise identifying information.
 *
 * We do not use your repository's remote URL, GitHub URL, or any other personally identifying
 * information to generate the project identifier hash. In this way it is almost completely anonymous.
 *
 * If you are running Astro outside of a git repository, then we will generate a unique, anonymous project
 * identifier by hashing your project's file path on your machine.
 *
 * ~~~
 *
 * Q: Can this project identifier be traced back to me?
 *
 * A: If your repository is private, there is no way for anyone to trace your unique
 * project identifier back to you, your organization, or your project. This is because it is itself
 * a hash of a commit hash, and a commit hash does not include any identifying information.
 *
 * If your repository is publicly available, then it is possible for someone to generate this unique
 * project identifier themselves by cloning your repo. Specifically, someone would need access to run
 * the `git rev-list` command below to generate this hash. Without this access, it is impossible to
 * trace the project identifier back to you or your project.
 *
 * If you are running Astro outside of a git repository, then the project identifier could be matched
 * back to the exact file path on your machine. It is unlikely (but still possible) for this to happen
 * without access to your machine or knowledge of your machine's file system.
 *
 * ~~~
 *
 * Q: I don't want Astro to collect a project identifier. How can I disable it?
 *
 * A: You can disable telemetry completely at any time by running `astro telemetry disable`. There is
 * currently no way to disable just this identifier while keeping the rest of telemetry enabled.
 */
export interface ProjectInfo {
    anonymousProjectId: string | undefined;
    isGit: boolean;
    packageManager: string | undefined;
    packageManagerVersion: string | undefined;
}
export declare function getProjectInfo(isCI: boolean): ProjectInfo;
