import { c as createComponent, m as maybeRenderHead, a as addAttribute, b as renderComponent, r as renderTemplate } from './astro/server_CQVWm2UQ.mjs';
import 'kleur/colors';
import { $ as $$Image } from './_astro_assets_DhhuFP3V.mjs';
/* empty css                         */

const $$TopEvents = createComponent(async ($$result, $$props, $$slots) => {
  const TOP_EVENTS_RESPONSE = await fetch("https://admin.iba-ju.edu.bd/api/admin/events");
  const TOP_EVENTS_DATA = await TOP_EVENTS_RESPONSE.json();
  const TOP_EVENTS = TOP_EVENTS_DATA.data;
  return renderTemplate`${maybeRenderHead()}<section class="event-area pt-40 pb-75" data-astro-cid-4wmbdoo2> <div class="container" data-astro-cid-4wmbdoo2> <!-- <div class="section-title text-center m-auto" data-cues="slideInUp">
      <h2>Upcoming Events</h2>
    </div> --> <div class="row justify-content-center" data-cues="slideInUp" data-astro-cid-4wmbdoo2> ${TOP_EVENTS.map((event) => {
    const event_date_time = new Date(event.event_meta.event_date);
    const formattedMonth = new Intl.DateTimeFormat("en-US", {
      month: "short"
    }).format(event_date_time);
    return renderTemplate`<div class="col-lg-4 col-md-6" data-astro-cid-4wmbdoo2> <div class="single-events-card pages-style" data-astro-cid-4wmbdoo2> <a class="text-decoration-none d-block image"${addAttribute(`/events/${event.id}`, "href")} data-astro-cid-4wmbdoo2> ${renderComponent($$result, "Image", $$Image, { "width": 500, "height": 500, "src": event.event_image, "alt": event.event_headline, "data-astro-cid-4wmbdoo2": true })} </a> <div class="content d-flex align-items-top" data-astro-cid-4wmbdoo2> <div class="date" data-astro-cid-4wmbdoo2> <h2 data-astro-cid-4wmbdoo2>${event_date_time.getDate()}</h2> <span data-astro-cid-4wmbdoo2>${formattedMonth}</span> </div> <div class="title" data-astro-cid-4wmbdoo2> <h3 data-astro-cid-4wmbdoo2> <a class="text-decoration-none"${addAttribute(`/events/${event.id}`, "href")} data-astro-cid-4wmbdoo2> ${event.event_headline} </a> </h3> <span class="d-flex align-items-center" data-astro-cid-4wmbdoo2> <i class="ri-calendar-line" data-astro-cid-4wmbdoo2></i> ${event.event_meta.event_time} </span> <span class="d-flex align-items-center" data-astro-cid-4wmbdoo2> <i class="ri-map-pin-line" data-astro-cid-4wmbdoo2></i> ${event.event_meta.event_place} </span> </div> </div> </div> </div>`;
  })} </div> </div> </section> `;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/events/TopEvents.astro", void 0);
const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/components/events/TopEvents.astro";
const $$url = void 0;

export { $$TopEvents as default, $$file as file, $$url as url };
