import { c as createComponent, m as maybeRenderHead, a as addAttribute, r as renderTemplate } from './astro/server_CQVWm2UQ.mjs';
import 'kleur/colors';
import 'clsx';
/* empty css                         */

const $$Academics = createComponent(async ($$result, $$props, $$slots) => {
  const PROGRAMS_RESPONSE = await fetch("https://admin.iba-ju.edu.bd/api/admin/programs");
  const PROGRAMS_DATA = await PROGRAMS_RESPONSE.json();
  const PROGRAMS = PROGRAMS_DATA.data;
  return renderTemplate`${maybeRenderHead()}<div class="programs-area pt-40 pb-75" data-astro-cid-sge2roof> <div class="container" data-astro-cid-sge2roof> <div class="programs-section-title" data-astro-cid-sge2roof> <div class="row align-items-center" data-astro-cid-sge2roof> <div class="col-lg-12" data-astro-cid-sge2roof> <header class="title text-center" data-astro-cid-sge2roof> <h2 data-astro-cid-sge2roof>Programs</h2> <p data-astro-cid-sge2roof>
Preparing students to make meaningful contributions to society as
              engaged citizens and leaders in a complex world
</p> </header> </div> </div> </div> <div class="programs-tab-content" data-astro-cid-sge2roof> <div class="grid-container" data-astro-cid-sge2roof> ${PROGRAMS.map((program) => renderTemplate`<div class="single-programs-card" data-astro-cid-sge2roof> <div class="content" data-astro-cid-sge2roof> <h3 data-astro-cid-sge2roof> <a class="text-decoration-none"${addAttribute(
    "/programs/" + program.id + "/?name=" + program.program_name,
    "href"
  )} data-astro-cid-sge2roof> ${program.program_name} </a> </h3> <p data-astro-cid-sge2roof>${program.program_title}</p> <p data-astro-cid-sge2roof>${program.program_details}</p> <a class="text-decoration-none arrow-btn"${addAttribute(
    "/programs/" + program.id + "/?name=" + program.program_name,
    "href"
  )} data-astro-cid-sge2roof>
Know More
<i class="flaticon-right-arrow" data-astro-cid-sge2roof></i> </a> </div> </div>`)} </div> </div> </div> </div> `;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/Academics.astro", void 0);
const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/components/Academics.astro";
const $$url = void 0;

export { $$Academics as default, $$file as file, $$url as url };
