import { c as createComponent, r as renderTemplate, m as maybeRenderHead, f as addAttribute, a as renderComponent } from '../chunks/astro/server_FQnuC0tz.mjs';
import 'kleur/colors';
import 'clsx';
/* empty css                                     */
import { $ as $$Layout } from '../chunks/Layout_DmzOhMIJ.mjs';
import { $ as $$PageLayout } from '../chunks/PageLayout_QCOvEKAv.mjs';
export { renderers } from '../renderers.mjs';

const $$AdmissionInfos = createComponent(async ($$result, $$props, $$slots) => {
  const PROGRAMS_RESPONSE = await fetch("https://admin.iba-ju.edu.bd/api/admin/programs");
  const PROGRAMS_DATA = await PROGRAMS_RESPONSE.json();
  const PROGRAMS = PROGRAMS_DATA.data;
  return renderTemplate`${maybeRenderHead()}<div class="programs-area pt-40 pb-75" data-astro-cid-ngt6mbpm> <div class="container" data-astro-cid-ngt6mbpm> <div class="programs-section-title" data-astro-cid-ngt6mbpm> <div class="row align-items-center" data-astro-cid-ngt6mbpm> <div class="col-lg-12" data-astro-cid-ngt6mbpm></div> </div> </div> <div class="programs-tab-content" data-astro-cid-ngt6mbpm> <div class="grid-container" data-astro-cid-ngt6mbpm> ${PROGRAMS.map((program) => {
    return renderTemplate`<div class="single-programs-card" data-astro-cid-ngt6mbpm> <div class="content" data-astro-cid-ngt6mbpm> <h3 data-astro-cid-ngt6mbpm> <a class="text-decoration-none arrow-btn"${addAttribute(
      "/programs/" + program.id + "/?name=" + program.program_name,
      "href"
    )} data-astro-cid-ngt6mbpm> ${program.program_name} <i class="flaticon-right-arrow" data-astro-cid-ngt6mbpm></i> </a> </h3> <p data-astro-cid-ngt6mbpm>${program.program_title}</p> <p data-astro-cid-ngt6mbpm>${program.program_details}</p> <a${addAttribute(program.program_portal, "href")} class="text-decoration-none arrow-btn" data-astro-cid-ngt6mbpm>
Apply Now
<i class="flaticon-right-arrow" data-astro-cid-ngt6mbpm></i> </a> </div> </div>`;
  })} </div> </div> </div> </div> `;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/AdmissionInfos.astro", undefined);

const $$Admission = createComponent(($$result, $$props, $$slots) => {
  return renderTemplate`${renderComponent($$result, "Layout", $$Layout, {}, { "default": ($$result2) => renderTemplate` ${renderComponent($$result2, "PageLayout", $$PageLayout, { "title": "Admission", "subtitle": "Explore the possibilities of an IBA education." }, { "default": ($$result3) => renderTemplate` ${renderComponent($$result3, "AdmissionInfos", $$AdmissionInfos, {})} ` })} ` })}`;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/pages/admission.astro", undefined);

const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/pages/admission.astro";
const $$url = "/admission";

const _page = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
  __proto__: null,
  default: $$Admission,
  file: $$file,
  url: $$url
}, Symbol.toStringTag, { value: 'Module' }));

const page = () => _page;

export { page };
