import { c as createComponent, r as renderTemplate, m as maybeRenderHead, f as addAttribute, a as renderComponent } from './astro/server_FQnuC0tz.mjs';
import 'kleur/colors';
import './index_CBkT0TfH.mjs';
import { $ as $$Image } from './_astro_assets_zG6zObmx.mjs';
/* empty css                         */

const $$NewsArea = createComponent(async ($$result, $$props, $$slots) => {
  const TOP_NEWS_RESPONSE = await fetch("https://admin.iba-ju.edu.bd/api/admin/news");
  const TOP_NEWS_DATA = await TOP_NEWS_RESPONSE.json();
  const TOP_NEWS = TOP_NEWS_DATA.data;
  return renderTemplate`<!-- Start Blog Area -->${maybeRenderHead()}<div class="grid-container" style="display: flex; gap: 1rem; flex-wrap: wrap" data-astro-cid-nt5kdftu> ${TOP_NEWS.length === 0 ? renderTemplate`<p style="width: 100%; text-align: center;" data-astro-cid-nt5kdftu>No New News!</p>` : null} ${TOP_NEWS.slice(0, 8).map((news, index, arr) => {
    const special_cases = arr.length > 5 && (index === 0 || index === arr.length - 1 && arr.length % 6 === 0);
    return renderTemplate`<article${addAttribute(`single-blog-card ${special_cases ? "focus--card" : null}`, "class")} style="max-width: 300px;" data-astro-cid-nt5kdftu> <div class="image" data-astro-cid-nt5kdftu> <a class="text-decoration-none"${addAttribute(`/news/${news.id}`, "href")} data-astro-cid-nt5kdftu> ${renderComponent($$result, "Image", $$Image, { "src": news.news_image, "alt": news.news_headline, "inferSize": true, "data-astro-cid-nt5kdftu": true })} </a> </div> <div class="content" data-astro-cid-nt5kdftu> <h3 data-astro-cid-nt5kdftu> <a class="text-decoration-none"${addAttribute(`/news/${news.id}`, "href")} data-astro-cid-nt5kdftu> ${news.news_headline} </a> </h3> <p data-astro-cid-nt5kdftu>${news.subtitle}</p> </div> </article>`;
  })} </div> <!-- End Blog Area --> <!-- <style>
  .grid-container article {
    max-height: fit-content;
    box-shadow:
      0 0 10px rgba(0, 0, 0, 0.15),
      0 3px 3px rgba(0, 0, 0, 0.15);
  }

  .single-blog-card .image {
    position: relative;
    /* margin-bottom: 20px; */
    transition: var(--transition);

    width: auto;
    height: auto;
    max-width: 100%;
    max-height: none;
    margin: 0;
  }

  .single-blog-card {
    position: relative;
  }

  .single-blog-card .image span {
    left: 15px;
    bottom: 15px;
    padding: 8px 16px;
    font-size: 14px;
    position: absolute;
    transition: var(--transition);
    background-color: var(--whiteColor);
  }
  .single-blog-card .image:hover span {
    color: var(--whiteColor);
    background-color: var(--primaryColor);
  }
  .single-blog-card .content {
    padding: 1rem;
  }
  .single-blog-card .content h3 {
    font-size: 18px;
    line-height: 1.6;
    margin-bottom: 15px;
  }

  .single-blog-card .content ul li {
    font-size: 14px;
    padding-left: 25px;
    position: relative;
    margin-right: 25px;
  }
  .single-blog-card .content ul li a {
    color: var(--paragraphColor);
  }
  .single-blog-card .content ul li a:hover {
    color: var(--primaryColor);
  }
  .single-blog-card .content ul li i {
    top: -2px;
    left: 0;
    font-size: 18px;
    position: absolute;
    color: var(--primaryColor);
  }
  .single-blog-card .content ul li:last-child {
    margin-right: 0;
  }
  .grid-container {
    display: flex;
    flex-flow: row wrap;
    /* justify-content: center; */
    align-items: stretch;
  }

  .grid-container > article img {
    display: block;
    overflow: hidden;
    position: relative;
    width: 100%;
    min-height: 1em;
    height: auto;
    object-fit: cover;
  }

  article .image {
    display: block;
  }

  @media only screen and (max-
width: 575px) {
    .grid-container {
      margin-left: -20px;
      margin-right: -20px;
      width: calc(100% + 40px);
    }
  }
  @media only screen and (min-width: 576px) {
    .grid-container {
      margin-left: -20px;
      margin-right: -20px;
      width: calc(100% + 40px);
    }
  }

  @media only screen and (min-width: 1024px) and (max-width: 1499px) {
    .grid-container {
      margin-left: -30px;
      margin-right: -30px;
      width: calc(100% + 60px);
    }
    .grid-container article.focus--card {
      width: calc(50% - 45px);
      margin-left: 30px;
      padding: 0;
      position: relative;
    }
    .grid-container article {
      width: calc(25% - 37.5px);
      margin-left: 30px;
      margin-bottom: 30px;
    }
  }

  @media only screen and (min-width: 768px) and (max-width: 1023px) {
    .grid-container article.focus--card:first-child {
      width: calc(66.6666666667% - 33.3333333333px);
      float: left;
      margin-left: 20px;
    }
  }
  @media only screen and (min-width: 768px) and (max-width: 1023px) {
    .grid-container article {
      margin-bottom: 20px;
      width: calc(33.3333333333% - 26.6666666667px);
      float: left;
      margin-left: 20px;
    }
  }

  @media only screen and (min-width: 576px) and (max-width: 767px) {
    .grid-container article.focus--card:first-child {
      width: calc(100% - 40px);
    }

    .grid-container article {
      margin-bottom: 20px;
      width: calc(50% - 30px);
      float: left;
      margin-left: 20px;
    }
  }

  @media only screen and (min-width: 576px) and (max-width: 767px) {
    .grid-container article {
      margin-bottom: 20px;
    }
  }

  @media only screen and (max-width: 575px) {
    .grid-container article {
      width: calc(100% - 20px);
      margin-left: 10px;
      margin-right: 10px;
      margin-bottom: 20px;
    }
  }

  @media only screen and (min-width: 576px) {
    article.focus--card .image {
      height: 100%;
    }

    article.focus--card .image img {
      height: 100%;
    }

    .single-blog-card.focus--card > .content {
      background: linear-gradient(180deg, transparent, rgba(0, 0, 0, 0.85) 80%);
      position: absolute;
      bottom: -2px;
      display: block;
      box-shadow: none;
      width: calc(100% + 2px);
      padding-bottom: 0;
    }

    .single-blog-card.focus--card .content a {
      color: var(--whiteColor);
    }
  }

  @media only screen and (min-width: 576px) and (max-width: 767px) {
    article.focus--card img {
      display: block;
      overflow: hidden;
      position: relative;
      width: 100%;
      min-height: 1em;
      height: auto;
      /* padding-top: 56.25%; */
    }
  }

  @media only screen and (min-width: 1024px) {
    article:last-child.focus--card {
      display: block;
    }
  }

  @media only screen and (max-width: 575px) {
    .grid-container > article:nth-child(n + 2) img {
      display: none;
    }
  }
</style> --> `;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/NewsArea.astro", undefined);
const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/components/NewsArea.astro";
const $$url = undefined;

export { $$NewsArea as default, $$file as file, $$url as url };
