import 'cookie';
import 'kleur/colors';
import { N as NOOP_MIDDLEWARE_FN } from './chunks/astro-designed-error-pages_VfEjXWLZ.mjs';
import 'es-module-lexer';
import { h as decodeKey } from './chunks/astro/server_FQnuC0tz.mjs';
import 'clsx';

function sanitizeParams(params) {
  return Object.fromEntries(
    Object.entries(params).map(([key, value]) => {
      if (typeof value === "string") {
        return [key, value.normalize().replace(/#/g, "%23").replace(/\?/g, "%3F")];
      }
      return [key, value];
    })
  );
}
function getParameter(part, params) {
  if (part.spread) {
    return params[part.content.slice(3)] || "";
  }
  if (part.dynamic) {
    if (!params[part.content]) {
      throw new TypeError(`Missing parameter: ${part.content}`);
    }
    return params[part.content];
  }
  return part.content.normalize().replace(/\?/g, "%3F").replace(/#/g, "%23").replace(/%5B/g, "[").replace(/%5D/g, "]");
}
function getSegment(segment, params) {
  const segmentPath = segment.map((part) => getParameter(part, params)).join("");
  return segmentPath ? "/" + segmentPath : "";
}
function getRouteGenerator(segments, addTrailingSlash) {
  return (params) => {
    const sanitizedParams = sanitizeParams(params);
    let trailing = "";
    if (addTrailingSlash === "always" && segments.length) {
      trailing = "/";
    }
    const path = segments.map((segment) => getSegment(segment, sanitizedParams)).join("") + trailing;
    return path || "/";
  };
}

function deserializeRouteData(rawRouteData) {
  return {
    route: rawRouteData.route,
    type: rawRouteData.type,
    pattern: new RegExp(rawRouteData.pattern),
    params: rawRouteData.params,
    component: rawRouteData.component,
    generate: getRouteGenerator(rawRouteData.segments, rawRouteData._meta.trailingSlash),
    pathname: rawRouteData.pathname || undefined,
    segments: rawRouteData.segments,
    prerender: rawRouteData.prerender,
    redirect: rawRouteData.redirect,
    redirectRoute: rawRouteData.redirectRoute ? deserializeRouteData(rawRouteData.redirectRoute) : undefined,
    fallbackRoutes: rawRouteData.fallbackRoutes.map((fallback) => {
      return deserializeRouteData(fallback);
    }),
    isIndex: rawRouteData.isIndex,
    origin: rawRouteData.origin
  };
}

function deserializeManifest(serializedManifest) {
  const routes = [];
  for (const serializedRoute of serializedManifest.routes) {
    routes.push({
      ...serializedRoute,
      routeData: deserializeRouteData(serializedRoute.routeData)
    });
    const route = serializedRoute;
    route.routeData = deserializeRouteData(serializedRoute.routeData);
  }
  const assets = new Set(serializedManifest.assets);
  const componentMetadata = new Map(serializedManifest.componentMetadata);
  const inlinedScripts = new Map(serializedManifest.inlinedScripts);
  const clientDirectives = new Map(serializedManifest.clientDirectives);
  const serverIslandNameMap = new Map(serializedManifest.serverIslandNameMap);
  const key = decodeKey(serializedManifest.key);
  return {
    // in case user middleware exists, this no-op middleware will be reassigned (see plugin-ssr.ts)
    middleware() {
      return { onRequest: NOOP_MIDDLEWARE_FN };
    },
    ...serializedManifest,
    assets,
    componentMetadata,
    inlinedScripts,
    clientDirectives,
    routes,
    serverIslandNameMap,
    key
  };
}

const manifest = deserializeManifest({"hrefRoot":"file:///E:/abir-vai/Ju-iba/ju-IBA/","adapterName":"@astrojs/vercel","routes":[{"file":"","links":[],"scripts":[],"styles":[],"routeData":{"type":"page","component":"_server-islands.astro","params":["name"],"segments":[[{"content":"_server-islands","dynamic":false,"spread":false}],[{"content":"name","dynamic":true,"spread":false}]],"pattern":"^\\/_server-islands\\/([^/]+?)\\/?$","prerender":false,"isIndex":false,"fallbackRoutes":[],"route":"/_server-islands/[name]","origin":"internal","_meta":{"trailingSlash":"ignore"}}},{"file":"campus-life/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/campus-life","isIndex":false,"type":"page","pattern":"^\\/campus-life\\/?$","segments":[[{"content":"campus-life","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/campus-life.astro","pathname":"/campus-life","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"events/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/events","isIndex":true,"type":"page","pattern":"^\\/events\\/?$","segments":[[{"content":"events","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/events/index.astro","pathname":"/events","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"faculty/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/faculty","isIndex":false,"type":"page","pattern":"^\\/faculty\\/?$","segments":[[{"content":"faculty","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/faculty.astro","pathname":"/faculty","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"message-from-director/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/message-from-director","isIndex":false,"type":"page","pattern":"^\\/message-from-director\\/?$","segments":[[{"content":"message-from-director","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/message-from-director.astro","pathname":"/message-from-director","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"news/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/news","isIndex":true,"type":"page","pattern":"^\\/news\\/?$","segments":[[{"content":"news","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/news/index.astro","pathname":"/news","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"notices/index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/notices","isIndex":true,"type":"page","pattern":"^\\/notices\\/?$","segments":[[{"content":"notices","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/notices/index.astro","pathname":"/notices","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"index.html","links":[],"scripts":[],"styles":[],"routeData":{"route":"/","isIndex":true,"type":"page","pattern":"^\\/$","segments":[],"params":[],"component":"src/pages/index.astro","pathname":"/","prerender":true,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"inline","content":"[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"type":"endpoint","isIndex":false,"route":"/_image","pattern":"^\\/_image\\/?$","segments":[[{"content":"_image","dynamic":false,"spread":false}]],"params":[],"component":"node_modules/astro/dist/assets/endpoint/generic.js","pathname":"/_image","prerender":false,"fallbackRoutes":[],"origin":"internal","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.AatXX1xK.css"},{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"inline","content":".martyr_monument_img[data-astro-cid-3zbxo6iv]{width:100%;object-fit:cover}header[data-astro-cid-3zbxo6iv] h1[data-astro-cid-3zbxo6iv]{text-align:center;margin-top:.8em;text-transform:capitalize}.content[data-astro-cid-3zbxo6iv] p[data-astro-cid-3zbxo6iv]{margin-inline:auto}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/admission","isIndex":false,"type":"page","pattern":"^\\/admission\\/?$","segments":[[{"content":"admission","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/admission.astro","pathname":"/admission","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"inline","content":".martyr_monument_img[data-astro-cid-3zbxo6iv]{width:100%;object-fit:cover}header[data-astro-cid-3zbxo6iv] h1[data-astro-cid-3zbxo6iv]{text-align:center;margin-top:.8em;text-transform:capitalize}.content[data-astro-cid-3zbxo6iv] p[data-astro-cid-3zbxo6iv]{margin-inline:auto}\n.contact-information[data-astro-cid-qzjs5yjj]{padding:40px;background-color:#f6f6f6;margin-top:74px;margin-bottom:25px}.contact-information[data-astro-cid-qzjs5yjj] h3[data-astro-cid-qzjs5yjj]{font-size:18px;margin-bottom:25px}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj]{margin-bottom:30px}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj] .icon[data-astro-cid-qzjs5yjj]{width:48px;height:42px;display:block;flex:0 0 auto;font-size:23px;line-height:42px;margin-right:20px;text-align:center;color:var(--blackColor);transition:var(--transition);background-color:var(--whiteColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj] .icon[data-astro-cid-qzjs5yjj]:hover{color:var(--whiteColor);background-color:var(--blackColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj] .content[data-astro-cid-qzjs5yjj] a[data-astro-cid-qzjs5yjj]{font-weight:500;color:var(--paragraphColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj] .content[data-astro-cid-qzjs5yjj] a[data-astro-cid-qzjs5yjj]:hover{color:var(--blackColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj] .content[data-astro-cid-qzjs5yjj] p[data-astro-cid-qzjs5yjj]{font-weight:500;color:var(--paragraphColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj]:hover .icon[data-astro-cid-qzjs5yjj]{color:var(--whiteColor);background-color:var(--blackColor)}.contact-information[data-astro-cid-qzjs5yjj] .information-card[data-astro-cid-qzjs5yjj]:last-child{margin-bottom:0}.contact-map[data-astro-cid-qzjs5yjj] iframe[data-astro-cid-qzjs5yjj]{width:100%;height:463px}\n.lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/contact-us","isIndex":false,"type":"page","pattern":"^\\/contact-us\\/?$","segments":[[{"content":"contact-us","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/contact-us.astro","pathname":"/contact-us","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"external","src":"/_astro/_id_.dc-dGZQA.css"},{"type":"inline","content":".lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/events/[id]","isIndex":false,"type":"page","pattern":"^\\/events\\/([^/]+?)\\/?$","segments":[[{"content":"events","dynamic":false,"spread":false}],[{"content":"id","dynamic":true,"spread":false}]],"params":["id"],"component":"src/pages/events/[id].astro","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"inline","content":".martyr_monument_img[data-astro-cid-3zbxo6iv]{width:100%;object-fit:cover}header[data-astro-cid-3zbxo6iv] h1[data-astro-cid-3zbxo6iv]{text-align:center;margin-top:.8em;text-transform:capitalize}.content[data-astro-cid-3zbxo6iv] p[data-astro-cid-3zbxo6iv]{margin-inline:auto}\n.lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\nul[data-astro-cid-3gohtqq7]{list-style:none;margin:0;padding:0}figure[data-astro-cid-3gohtqq7]{margin:0}figcaption[data-astro-cid-3gohtqq7]{font-style:italic;font-size:.8em;color:gray;line-height:1.4}.grid[data-astro-cid-3gohtqq7]{display:grid;grid-auto-flow:column;grid-auto-columns:90%;grid-gap:1em;overflow-x:scroll;-webkit-overflow-scrolling:touch;padding:2em 1em;background:#fff}@media (min-width: 600px){.grid[data-astro-cid-3gohtqq7]{grid-auto-flow:initial;grid-template-columns:repeat(auto-fit,minmax(auto,20em));justify-content:center;overflow-x:auto}}.grid__figure[data-astro-cid-3gohtqq7]{display:grid;grid-template-rows:15em 1fr;grid-gap:1em}.grid__figure[data-astro-cid-3gohtqq7] img[data-astro-cid-3gohtqq7]{width:100%;height:100%;object-fit:cover}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/gallery","isIndex":false,"type":"page","pattern":"^\\/gallery\\/?$","segments":[[{"content":"gallery","dynamic":false,"spread":false}]],"params":[],"component":"src/pages/gallery.astro","pathname":"/gallery","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"external","src":"/_astro/_id_.DgCsgF8t.css"},{"type":"inline","content":".lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/news/[id]","isIndex":false,"type":"page","pattern":"^\\/news\\/([^/]+?)\\/?$","segments":[[{"content":"news","dynamic":false,"spread":false}],[{"content":"id","dynamic":true,"spread":false}]],"params":["id"],"component":"src/pages/news/[id].astro","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"inline","content":".lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n"},{"type":"external","src":"/_astro/_id_.CD6TZS6x.css"}],"routeData":{"route":"/notices/[id]","isIndex":false,"type":"page","pattern":"^\\/notices\\/([^/]+?)\\/?$","segments":[[{"content":"notices","dynamic":false,"spread":false}],[{"content":"id","dynamic":true,"spread":false}]],"params":["id"],"component":"src/pages/notices/[id].astro","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}},{"file":"","links":[],"scripts":[],"styles":[{"type":"external","src":"/_astro/admission.dHBsZ3t3.css"},{"type":"inline","content":".newsletter-content[data-astro-cid-ottoqkhq]{background-color:#f4f4f4;padding:2rem;text-align:center;background:#020024;background:linear-gradient(0deg,#020024,#271cc7 35%,#090979)}.newsletter-content[data-astro-cid-ottoqkhq] .title[data-astro-cid-ottoqkhq]{margin-bottom:35px}.newsletter-content[data-astro-cid-ottoqkhq] .title[data-astro-cid-ottoqkhq] h2[data-astro-cid-ottoqkhq]{font-size:42px;line-height:1.3;margin-bottom:13px;color:var(--whiteColor)}.newsletter-content[data-astro-cid-ottoqkhq] .title[data-astro-cid-ottoqkhq] p[data-astro-cid-ottoqkhq]{color:var(--whiteColor)}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq]{margin-right:30px}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq] .default-btn[data-astro-cid-ottoqkhq]:hover{color:var(--whiteColor)!important;background-color:var(--blackColor)}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq] .arrow-btn[data-astro-cid-ottoqkhq]:before{background-color:var(--blackColor)}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq] .arrow-btn[data-astro-cid-ottoqkhq]:hover{color:var(--whiteColor)}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq] .arrow-btn[data-astro-cid-ottoqkhq]:hover:after{background-color:var(--whiteColor)}.newsletter-content[data-astro-cid-ottoqkhq] .subscribe-btn[data-astro-cid-ottoqkhq] li[data-astro-cid-ottoqkhq]:last-child{margin-right:0}.newsletter-content[data-astro-cid-ottoqkhq].pages-style{margin-right:0}.curriculum-content[data-astro-cid-nvvdbdcv]{padding:2rem;text-align:center}.curriculum-content[data-astro-cid-nvvdbdcv] h2[data-astro-cid-nvvdbdcv]{text-align:center}section[data-astro-cid-nvvdbdcv] header[data-astro-cid-nvvdbdcv] h2[data-astro-cid-nvvdbdcv]{font-size:clamp(1rem,-1.5rem + 8vw,3rem);margin-bottom:15px}\n.martyr_monument_img[data-astro-cid-3zbxo6iv]{width:100%;object-fit:cover}header[data-astro-cid-3zbxo6iv] h1[data-astro-cid-3zbxo6iv]{text-align:center;margin-top:.8em;text-transform:capitalize}.content[data-astro-cid-3zbxo6iv] p[data-astro-cid-3zbxo6iv]{margin-inline:auto}\n.lds-ring[data-astro-cid-tapyucl4],.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box}.lds-ring[data-astro-cid-tapyucl4]{display:inline-block;position:relative;width:80px;height:80px}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid var(--primaryColor);border-radius:50%;animation:lds-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:var(--primaryColor) transparent transparent transparent}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(1){animation-delay:-.45s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(2){animation-delay:-.3s}.lds-ring[data-astro-cid-tapyucl4] div[data-astro-cid-tapyucl4]:nth-child(3){animation-delay:-.15s}@keyframes lds-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}}\n.program-card[data-astro-cid-kaoq3tvj]{margin-bottom:25px;text-align:center}.program-card[data-astro-cid-kaoq3tvj] h2[data-astro-cid-kaoq3tvj]{font-size:clamp(1rem,-1.5rem + 8vw,3rem);margin-bottom:15px}.content[data-astro-cid-kaoq3tvj]{display:flex;flex-direction:column;justify-content:space-around;background:linear-gradient(to left,var(--whiteColor) 60%,white 40%)}.content[data-astro-cid-kaoq3tvj]>[data-astro-cid-kaoq3tvj]{flex:1}section[data-astro-cid-kaoq3tvj] header[data-astro-cid-kaoq3tvj] h2[data-astro-cid-kaoq3tvj]{font-size:clamp(1rem,-1.5rem + 8vw,3rem);margin-bottom:15px}.content[data-astro-cid-kaoq3tvj] .content--image[data-astro-cid-kaoq3tvj]{margin:1rem 0;align-self:center;display:flex;justify-content:center;align-items:center}.content[data-astro-cid-kaoq3tvj] .content--text[data-astro-cid-kaoq3tvj]{padding:2rem}.content[data-astro-cid-kaoq3tvj].inverse{background-color:#f6f6f6}.wrapper[data-astro-cid-kaoq3tvj]{background-color:var(--whiteColor)}section[data-astro-cid-kaoq3tvj].inverse .content[data-astro-cid-kaoq3tvj] .content--text[data-astro-cid-kaoq3tvj]{background-color:#f6f6f6}@media only screen and (min-width: 768px){.content[data-astro-cid-kaoq3tvj]{flex-direction:row;background:linear-gradient(to right,#f6f6f6 60%,transparent 40%)}section[data-astro-cid-kaoq3tvj].inverse>.content--text[data-astro-cid-kaoq3tvj]{order:2}section[data-astro-cid-kaoq3tvj].inverse>.content--image[data-astro-cid-kaoq3tvj]{order:1}.content[data-astro-cid-kaoq3tvj].inverse{background:linear-gradient(to left,#f6f6f6 60%,transparent 20%)}}\n[data-astro-image]{width:100%;height:auto;object-fit:var(--fit);object-position:var(--pos);aspect-ratio:var(--w) / var(--h)}[data-astro-image=responsive]{max-width:calc(var(--w) * 1px);max-height:calc(var(--h) * 1px)}[data-astro-image=fixed]{width:calc(var(--w) * 1px);height:calc(var(--h) * 1px)}\n"}],"routeData":{"route":"/programs/[program]","isIndex":false,"type":"page","pattern":"^\\/programs\\/([^/]+?)\\/?$","segments":[[{"content":"programs","dynamic":false,"spread":false}],[{"content":"program","dynamic":true,"spread":false}]],"params":["program"],"component":"src/pages/programs/[program].astro","prerender":false,"fallbackRoutes":[],"distURL":[],"origin":"project","_meta":{"trailingSlash":"ignore"}}}],"base":"/","trailingSlash":"ignore","compressHTML":true,"componentMetadata":[["E:/abir-vai/Ju-iba/ju-IBA/src/pages/index.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/admission.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/campus-life.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/contact-us.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/events/[id].astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/events/index.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/faculty.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/gallery.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/message-from-director.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/news/[id].astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/news/index.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/notices/[id].astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/notices/index.astro",{"propagation":"none","containsHead":true}],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/programs/[program].astro",{"propagation":"none","containsHead":true}]],"renderers":[],"clientDirectives":[["idle","(()=>{var l=(n,t)=>{let i=async()=>{await(await n())()},e=typeof t.value==\"object\"?t.value:void 0,s={timeout:e==null?void 0:e.timeout};\"requestIdleCallback\"in window?window.requestIdleCallback(i,s):setTimeout(i,s.timeout||200)};(self.Astro||(self.Astro={})).idle=l;window.dispatchEvent(new Event(\"astro:idle\"));})();"],["load","(()=>{var e=async t=>{await(await t())()};(self.Astro||(self.Astro={})).load=e;window.dispatchEvent(new Event(\"astro:load\"));})();"],["media","(()=>{var n=(a,t)=>{let i=async()=>{await(await a())()};if(t.value){let e=matchMedia(t.value);e.matches?i():e.addEventListener(\"change\",i,{once:!0})}};(self.Astro||(self.Astro={})).media=n;window.dispatchEvent(new Event(\"astro:media\"));})();"],["only","(()=>{var e=async t=>{await(await t())()};(self.Astro||(self.Astro={})).only=e;window.dispatchEvent(new Event(\"astro:only\"));})();"],["visible","(()=>{var a=(s,i,o)=>{let r=async()=>{await(await s())()},t=typeof i.value==\"object\"?i.value:void 0,c={rootMargin:t==null?void 0:t.rootMargin},n=new IntersectionObserver(e=>{for(let l of e)if(l.isIntersecting){n.disconnect(),r();break}},c);for(let e of o.children)n.observe(e)};(self.Astro||(self.Astro={})).visible=a;window.dispatchEvent(new Event(\"astro:visible\"));})();"]],"entryModules":{"\u0000@astrojs-ssr-adapter":"_@astrojs-ssr-adapter.mjs","\u0000noop-middleware":"_noop-middleware.mjs","\u0000@astro-renderers":"renderers.mjs","\u0000@astro-page:src/pages/contact-us@_@astro":"pages/contact-us.astro.mjs","\u0000@astro-page:src/pages/events/index@_@astro":"pages/events.astro.mjs","\u0000@astro-page:src/pages/faculty@_@astro":"pages/faculty.astro.mjs","\u0000@astro-page:src/pages/gallery@_@astro":"pages/gallery.astro.mjs","\u0000@astro-page:src/pages/message-from-director@_@astro":"pages/message-from-director.astro.mjs","\u0000@astro-page:src/pages/news/index@_@astro":"pages/news.astro.mjs","\u0000@astro-page:src/pages/notices/index@_@astro":"pages/notices.astro.mjs","\u0000@astrojs-ssr-virtual-entry":"entry.mjs","\u0000@astro-page:node_modules/astro/dist/assets/endpoint/generic@_@js":"pages/_image.astro.mjs","\u0000@astro-page:src/pages/admission@_@astro":"pages/admission.astro.mjs","\u0000@astro-page:src/pages/campus-life@_@astro":"pages/campus-life.astro.mjs","\u0000@astro-page:src/pages/events/[id]@_@astro":"pages/events/_id_.astro.mjs","\u0000@astro-page:src/pages/news/[id]@_@astro":"pages/news/_id_.astro.mjs","\u0000@astro-page:src/pages/notices/[id]@_@astro":"pages/notices/_id_.astro.mjs","\u0000@astro-page:src/pages/programs/[program]@_@astro":"pages/programs/_program_.astro.mjs","\u0000@astro-page:src/pages/index@_@astro":"pages/index.astro.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/contact-us/ContactInformations.astro":"chunks/ContactInformations_ErKSFl7G.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/news/TopNews.astro":"chunks/TopNews_DMpbV27h.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/message-from-director/MessageDetails.astro":"chunks/MessageDetails_C-d28T8n.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/GalleryComponent.astro":"chunks/GalleryComponent_BIXr_uhZ.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/news/NewsDetails.astro":"chunks/NewsDetails_B9i93BAL.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/notices/TopNotices.astro":"chunks/TopNotices_CDuj8h0k.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/ProgramDetails.astro":"chunks/ProgramDetails_CEpVisUQ.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/Curriculum.astro":"chunks/Curriculum_C87obZAU.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/events/TopEvents.astro":"chunks/TopEvents_ZcR-vIds.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/notices/NoticeDetails.astro":"chunks/NoticeDetails_CC6e2Cqb.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/events/EventDetails.astro":"chunks/EventDetails_BM4fZtlp.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/faculty/FacultyList.astro":"chunks/FacultyList_DlqoSrMl.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/Academics.astro":"chunks/Academics_C6qtgIEl.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/NewsArea.astro":"chunks/NewsArea_iiksDHVr.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/components/Carousel.astro":"chunks/Carousel_CB2HEhl6.mjs","E:/abir-vai/Ju-iba/ju-IBA/node_modules/astro/dist/assets/services/sharp.js":"chunks/sharp_ByCChut-.mjs","\u0000@astrojs-manifest":"manifest_CuIfgitV.mjs","E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro?astro&type=script&index=0&lang.ts":"_astro/Layout.astro_astro_type_script_index_0_lang.DA_WglpU.js","E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro?astro&type=script&index=1&lang.ts":"_astro/Layout.astro_astro_type_script_index_1_lang.jw2IlNBD.js","E:/abir-vai/Ju-iba/ju-IBA/src/layouts/PageLayout.astro?astro&type=script&index=0&lang.ts":"_astro/PageLayout.astro_astro_type_script_index_0_lang.Dh34Mfog.js","E:/abir-vai/Ju-iba/ju-IBA/src/pages/news/_newsLayout.astro?astro&type=script&index=0&lang.ts":"_astro/_newsLayout.astro_astro_type_script_index_0_lang.D0Tqwqbq.js","E:/abir-vai/Ju-iba/ju-IBA/src/pages/notices/_noticesLayout.astro?astro&type=script&index=0&lang.ts":"_astro/_noticesLayout.astro_astro_type_script_index_0_lang.D0Tqwqbq.js","E:/abir-vai/Ju-iba/ju-IBA/src/pages/events/_eventsLayout.astro?astro&type=script&index=0&lang.ts":"_astro/_eventsLayout.astro_astro_type_script_index_0_lang.D0Tqwqbq.js","E:/abir-vai/Ju-iba/ju-IBA/src/components/Collaborators.astro?astro&type=script&index=0&lang.ts":"_astro/Collaborators.astro_astro_type_script_index_0_lang.DbtdhJo5.js","astro:scripts/before-hydration.js":""},"inlinedScripts":[["E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro?astro&type=script&index=0&lang.ts","const n=()=>{if(window.location.pathname===\"/\"){const t=document.getElementById(\"navbar\"),e=document.getElementById(\"top-navbar\");window.addEventListener(\"scroll\",()=>{window.scrollY>500?(t?.classList.remove(\"transparent\"),e?.classList.remove(\"transparent\"),t?.classList.add(\"colored\"),e?.classList.add(\"colored\")):(t?.classList.add(\"transparent\"),e?.classList.add(\"transparent\"),t?.classList.remove(\"colored\"),e?.classList.remove(\"colored\"))})}},o=()=>{const t=document.querySelectorAll(\".responsive-menu-list a\");function e(s){const a=s.target;a&&(s.stopPropagation(),a.parentElement?.classList.contains(\"active\")?a.parentElement?.classList.remove(\"active\"):a.parentElement?.classList.add(\"active\"))}for(let s=0;s<t.length;s++)t[s].addEventListener(\"click\",e)};document.addEventListener(\"DOMContentLoaded\",()=>{n(),o()});"],["E:/abir-vai/Ju-iba/ju-IBA/src/layouts/PageLayout.astro?astro&type=script&index=0&lang.ts","document.addEventListener(\"DOMContentLoaded\",()=>{const n=document.getElementById(\"navbar\"),t=document.getElementById(\"main\");if(n&&t){const e=()=>{const o=n.getBoundingClientRect(),a=o.top>=0?o.top:0,d=n.offsetHeight+a;t.style.paddingTop=`${d}px`};e(),window.addEventListener(\"resize\",e)}});"],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/news/_newsLayout.astro?astro&type=script&index=0&lang.ts","const n=document.getElementById(\"navbar\"),a=document.getElementById(\"main\");if(n&&a){const t=()=>{const e=n.getBoundingClientRect(),o=e.top>=0?e.top:0,d=n.offsetHeight+o;a.style.paddingTop=`${d}px`};t(),window.addEventListener(\"resize\",t)}"],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/notices/_noticesLayout.astro?astro&type=script&index=0&lang.ts","const n=document.getElementById(\"navbar\"),a=document.getElementById(\"main\");if(n&&a){const t=()=>{const e=n.getBoundingClientRect(),o=e.top>=0?e.top:0,d=n.offsetHeight+o;a.style.paddingTop=`${d}px`};t(),window.addEventListener(\"resize\",t)}"],["E:/abir-vai/Ju-iba/ju-IBA/src/pages/events/_eventsLayout.astro?astro&type=script&index=0&lang.ts","const n=document.getElementById(\"navbar\"),a=document.getElementById(\"main\");if(n&&a){const t=()=>{const e=n.getBoundingClientRect(),o=e.top>=0?e.top:0,d=n.offsetHeight+o;a.style.paddingTop=`${d}px`};t(),window.addEventListener(\"resize\",t)}"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/Collaborators.astro?astro&type=script&index=0&lang.ts","const o=document.querySelectorAll(\".scroller\");window.matchMedia(\"(prefers-reduced-motion: reduce)\").matches||c();function c(){o.forEach(e=>{e.setAttribute(\"data-animated\",\"true\");const r=e.querySelector(\".scroller__inner\");Array.from(r.children).forEach(n=>{const t=n.cloneNode(!0);t.setAttribute(\"aria-hidden\",\"true\"),r.appendChild(t)})})}"]],"assets":["/_astro/martyr_monument_114fef2d81._Fg0_iJ3.webp","/_astro/amar_ekushey.B9r5nDWv.jpg","/_astro/arts_culture.x4l6-zxo.jpg","/_astro/central_mosque.2HLzWgOR.jpg","/_astro/campus365-logo.GMFv-B1e.png","/_astro/ju_logo.D-hPRl65.svg","/_astro/flaticonbbdb.B4Ax8Agv.ttf","/_astro/poppins-latin-ext-400-normal.by3JarPu.woff2","/_astro/poppins-latin-400-normal.cpxAROuN.woff2","/_astro/roboto-slab-cyrillic-400-normal.Cle_1eKm.woff2","/_astro/roboto-slab-cyrillic-ext-400-normal.SiMiJRQ6.woff2","/_astro/roboto-slab-greek-400-normal.BMhfaf5e.woff2","/_astro/roboto-slab-vietnamese-400-normal.Bc4dlO66.woff2","/_astro/roboto-slab-latin-ext-400-normal.DcScOPIk.woff2","/_astro/roboto-slab-latin-400-normal.BugDaDM0.woff2","/_astro/remixicon117c.DUK49BtM.eot","/_astro/poppins-latin-200-normal.B8tqA5oA.woff2","/_astro/poppins-latin-ext-200-normal.C8LeRBwY.woff2","/_astro/poppins-latin-400-normal.BOb3E3N0.woff","/_astro/flaticonbbdb.Z2_Qlyho.woff","/_astro/roboto-slab-cyrillic-400-normal.CEPIJkab.woff","/_astro/poppins-latin-ext-400-normal.DaBSavcJ.woff","/_astro/roboto-slab-greek-400-normal.BgdlsbFb.woff","/_astro/roboto-slab-cyrillic-ext-400-normal.CEF08sgq.woff","/_astro/roboto-slab-vietnamese-400-normal.DI5s1HlO.woff","/_astro/remixicon117c.BVOYbT3K.woff2","/_astro/roboto-slab-latin-ext-400-normal.BXRSMiTE.woff","/_astro/roboto-slab-latin-400-normal.Bf40fG0K.woff","/_astro/poppins-latin-200-normal.BxK-3Qw6.woff","/_astro/poppins-latin-ext-200-normal.BnXTLz5G.woff","/_astro/flaticonbbdb.587hawnO.woff2","/_astro/remixicon117c.DfzPQSMi.woff","/_astro/flaticonbbdb.ByQZWBMi.eot","/_astro/flaticonbbdb.BQSH1c_1.svg","/_astro/remixicon117c.D9ZyeRwQ.ttf","/_astro/remixicon117c.Cu7lBgHe.svg","/_astro/_id_.CD6TZS6x.css","/_astro/_id_.DgCsgF8t.css","/_astro/_id_.dc-dGZQA.css","/_astro/admission.AatXX1xK.css","/_astro/admission.dHBsZ3t3.css","/_astro/index.w0npuPne.css","/_astro/index.Iay278hg.css","/favicon.svg","/ju_logo.svg","/data/index.json","/_astro/Layout.astro_astro_type_script_index_1_lang.jw2IlNBD.js","/assets/img/graduets-5.svg","/assets/img/ju-illustration.jpg","/assets/img/JU_Logo.jpg","/assets/img/title-shape.svg","/assets/img/bg/bg-2.jpg","/assets/img/bg/martyr_monument_114fef2d81.webp","/assets/img/blog/blog-1.jpg","/assets/img/blog/blog-10.jpg","/assets/img/blog/blog-2.jpg","/assets/img/blog/blog-3.jpg","/assets/img/blog/blog-4.jpg","/assets/img/blog/blog-5.jpg","/assets/img/blog/blog-6.jpg","/assets/img/blog/blog-7.jpg","/assets/img/blog/blog-8.jpg","/assets/img/blog/blog-9.jpg","/assets/img/faculty/faculty-1.jpg","/assets/img/faculty/Ireen-2024.jpeg","/assets/img/js/swiperSlide.js","/assets/img/overview/overview-1.jpg","/assets/img/overview/overview-2.jpg","/assets/img/overview/overview-3.svg","/campus-life/index.html","/events/index.html","/faculty/index.html","/message-from-director/index.html","/news/index.html","/notices/index.html","/index.html"],"buildFormat":"directory","checkOrigin":true,"serverIslandNameMap":[["E:/abir-vai/Ju-iba/ju-IBA/src/components/contact-us/ContactInformations.astro","ContactInformations"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/news/TopNews.astro","TopNews"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/message-from-director/MessageDetails.astro","MessageDetails"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/GalleryComponent.astro","GalleryComponent"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/news/NewsDetails.astro","NewsDetails"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/notices/TopNotices.astro","TopNotices"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/ProgramDetails.astro","ProgramDetails"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/Curriculum.astro","Curriculum"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/events/TopEvents.astro","TopEvents"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/notices/NoticeDetails.astro","NoticeDetails"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/events/EventDetails.astro","EventDetails"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/faculty/FacultyList.astro","FacultyList"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/NewsArea.astro","NewsArea"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/Academics.astro","Academics"],["E:/abir-vai/Ju-iba/ju-IBA/src/components/Carousel.astro","Carousel"]],"key":"zFwnRdPhNfT0DKZGuuC2bV1M6+HKWgaehXCDhLJdam4="});
if (manifest.sessionConfig) manifest.sessionConfig.driverModule = null;

export { manifest };
