import { c as createComponent, r as renderTemplate, f as addAttribute, e as createAstro, a as renderComponent, g as renderHead, b as renderSlot, d as renderScript } from './astro/server_FQnuC0tz.mjs';
import 'kleur/colors';
/* empty css                             */
import 'clsx';

const campus365Logo = new Proxy({"src":"/_astro/campus365-logo.GMFv-B1e.png","width":1534,"height":628,"format":"png"}, {
						get(target, name, receiver) {
							if (name === 'clone') {
								return structuredClone(target);
							}
							if (name === 'fsPath') {
								return "E:/abir-vai/Ju-iba/ju-IBA/src/assets/img/campus365-logo.png";
							}
							
							return target[name];
						}
					});

const $$Astro$1 = createAstro();
const $$SeoMeta = createComponent(($$result, $$props, $$slots) => {
  const Astro2 = $$result.createAstro($$Astro$1, $$props, $$slots);
  Astro2.self = $$SeoMeta;
  const {
    title = "JU | Institute of Business Administration",
    description = "Official website of Jahangirnagar University Business Administration.",
    keywords = "JU, university, business, administration, education, notice, admission"
  } = Astro2.props;
  return renderTemplate`<title>${title}</title><meta name="description"${addAttribute(description, "content")}><meta name="keywords"${addAttribute(keywords, "content")}><!-- Open Graph / Facebook --><meta property="og:type" content="website"><meta property="og:title"${addAttribute(title, "content")}><meta property="og:description"${addAttribute(description, "content")}><!-- Twitter --><meta name="twitter:card" content="summary_large_image"><meta name="twitter:title"${addAttribute(title, "content")}><meta name="twitter:description"${addAttribute(description, "content")}>`;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/seo/SeoMeta.astro", undefined);

const $$Astro = createAstro();
const $$Layout = createComponent(async ($$result, $$props, $$slots) => {
  const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
  Astro2.self = $$Layout;
  const { title, description, keywords } = Astro2.props;
  const logo_response = await fetch(
    "https://admin.iba-ju.edu.bd/api/admin/logo"
  );
  const logo_data = await logo_response.json();
  const { pathname } = Astro2.url;
  const isIndexPage = pathname === "/";
  return renderTemplate`<html lang="en" data-astro-cid-sckkx6r4> <head><meta charset="UTF-8"><meta name="viewport" content="width=device-width">${renderComponent($$result, "SeoMeta", $$SeoMeta, { "title": title, "description": description, "keywords": keywords, "data-astro-cid-sckkx6r4": true })}<link rel="icon" type="image/svg+xml" href="/ju_logo.svg"><meta name="generator"${addAttribute(Astro2.generator, "content")}><!-- <title>Institute of Business Administration</title> --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">${renderHead()}</head> <body data-astro-cid-sckkx6r4> <!-- Start Navbar Area --> <header class="custom-navbar" style="position: fixed; top: 0; z-index: 3;" data-astro-cid-sckkx6r4> <div id="top-navbar"${addAttribute(`top-header-area style-2 ${isIndexPage ? "transparent" : "colored"}`, "class")} data-astro-cid-sckkx6r4> <div class="container" data-astro-cid-sckkx6r4> <div class="row align-items-center" data-astro-cid-sckkx6r4> <div class="col-lg-6 col-md-6" data-astro-cid-sckkx6r4> <div class="top-header-list style-2" data-astro-cid-sckkx6r4> <ul class="list-unstyled ps-0 mb-0" data-astro-cid-sckkx6r4> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="navbar-brand" href="/" data-astro-cid-sckkx6r4>Institute of Business Administration</a> </li> </ul> </div> </div> <div class="col-lg-6 col-md-6" data-astro-cid-sckkx6r4> <div class="top-header-social-list text-end" data-astro-cid-sckkx6r4> <ul class="list-unstyled ps-0 mb-0" data-astro-cid-sckkx6r4> <li class="d-inline-block" data-astro-cid-sckkx6r4> <ul class="list-unstyled ps-0 mb-0 pages-link" data-astro-cid-sckkx6r4> <li class="d-inline-block" data-astro-cid-sckkx6r4>Informations for:</li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/faculty" data-astro-cid-sckkx6r4>Faculty & Staff</a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/admission" data-astro-cid-sckkx6r4>Admission</a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/gallery" data-astro-cid-sckkx6r4>Gallery</a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/contact-us" data-astro-cid-sckkx6r4>Contact</a> </li> </ul> </li> </ul> </div> </div> </div> </div> </div> <nav id="navbar"${addAttribute(`navbar navbar-expand-lg style-2 ${isIndexPage ? "transparent" : "colored"}`, "class")} data-astro-cid-sckkx6r4> <div class="container" data-astro-cid-sckkx6r4> <a class="navbar-brand" href="/" data-astro-cid-sckkx6r4> <img${addAttribute(logo_data.data.value, "src")} alt="ju_IBA_logo" width="100" data-astro-cid-sckkx6r4> </a> <a class="navbar-toggler text-decoration-none" data-bs-toggle="offcanvas" href="#navbarOffcanvas" role="button" aria-controls="navbarOffcanvas" data-astro-cid-sckkx6r4> <span class="burger-menu" data-astro-cid-sckkx6r4> <span class="top-bar" data-astro-cid-sckkx6r4></span> <span class="middle-bar" data-astro-cid-sckkx6r4></span> <span class="bottom-bar" data-astro-cid-sckkx6r4></span> </span> </a> <div class="collapse navbar-collapse" data-astro-cid-sckkx6r4> <div class="menu" data-astro-cid-sckkx6r4> <div class="logo-wrapper" data-astro-cid-sckkx6r4> <a href="/" data-astro-cid-sckkx6r4> <div class="logo-bg" data-astro-cid-sckkx6r4> <img${addAttribute(logo_data.data.value, "src")} alt="ju_IBA_logo" width="95" data-astro-cid-sckkx6r4> </div> </a> </div> <ul class="navbar-nav" data-astro-cid-sckkx6r4> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/" class="nav-link" data-astro-cid-sckkx6r4> Home </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="javascript:void(0)" class="dropdown-toggle nav-link" data-astro-cid-sckkx6r4>
Programs
</a> <ul class="dropdown-menu" data-astro-cid-sckkx6r4> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/1/?name=Undergraduate" class="nav-link" data-astro-cid-sckkx6r4>
Undergraduate
</a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/2/?name=graduate" class="nav-link" data-astro-cid-sckkx6r4>
Graduate
</a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/3/?name=Wmba" class="nav-link" data-astro-cid-sckkx6r4> WMBA </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/4/?name=M.phil / phd" class="nav-link" data-astro-cid-sckkx6r4>
M.Phil / P.hD
</a> </li> </ul> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/events" class="nav-link" data-astro-cid-sckkx6r4> Events </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/news" class="nav-link" data-astro-cid-sckkx6r4> News </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/notices" class="nav-link" data-astro-cid-sckkx6r4> Notices </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/campus-life" class="nav-link" data-astro-cid-sckkx6r4> Campus Life </a> </li> </ul> </div> </div> </div> </nav> <!-- End Navbar Area --> <!-- Start Responsive Navbar Area --> <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas" data-astro-cid-sckkx6r4> <div class="offcanvas-header" data-astro-cid-sckkx6r4> <a class="logo d-inline-block" href="/" data-astro-cid-sckkx6r4> <img${addAttribute(logo_data.data.value, "src")} alt="ju_IBA_logo" width="50" data-astro-cid-sckkx6r4> </a> <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close" data-astro-cid-sckkx6r4> <i class="ri-close-fill" data-astro-cid-sckkx6r4></i> </button> </div> <div class="offcanvas-body" data-astro-cid-sckkx6r4> <ul class="responsive-menu" data-astro-cid-sckkx6r4> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/" class="nav-link" data-astro-cid-sckkx6r4> Home </a> </li> <li class="responsive-menu-list" data-astro-cid-sckkx6r4> <a href="javascript:void(0);" data-astro-cid-sckkx6r4>Programs</a> <ul class="responsive-menu-items" data-astro-cid-sckkx6r4> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/1/?name=Undergraduate" class="nav-link" data-astro-cid-sckkx6r4>
Undergraduate
</a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/2/?name=graduate" class="nav-link" data-astro-cid-sckkx6r4>
Graduate
</a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/3/?name=Wmba" class="nav-link" data-astro-cid-sckkx6r4> WMBA </a> </li> <li class="nav-item" data-astro-cid-sckkx6r4> <a href="/programs/4/?name=M.phil / phd" class="nav-link" data-astro-cid-sckkx6r4>
M.Phil / P.hD
</a> </li> </ul> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/admission" class="nav-link" data-astro-cid-sckkx6r4> Admission </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/news" class="nav-link" data-astro-cid-sckkx6r4> News </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/events" class="nav-link" data-astro-cid-sckkx6r4> Events </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/notices" class="nav-link" data-astro-cid-sckkx6r4> Notices </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/faculty" class="nav-link" data-astro-cid-sckkx6r4> Faculty </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/campus-life" class="nav-link" data-astro-cid-sckkx6r4> Campus Life </a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/gallery" class="nav-link" data-astro-cid-sckkx6r4>Gallery</a> </li> <li class="responsive-menu-list without-icon" data-astro-cid-sckkx6r4> <a href="/contact-us" class="nav-link" data-astro-cid-sckkx6r4> Contact Us </a> </li> </ul> </div> </div> </header> <!-- End Responsive Navbar Area --> <main data-astro-cid-sckkx6r4> ${renderSlot($$result, $$slots["default"])} </main> <div class="footer-area" style="background-color: #c4dff4;" data-astro-cid-sckkx6r4> <div class="container" data-astro-cid-sckkx6r4> <div class="row" data-astro-cid-sckkx6r4> <div class="col-lg-12 col-sm-12" data-astro-cid-sckkx6r4> <div class="row" data-cues="slideInUp" data-astro-cid-sckkx6r4> <div class="col-lg-3 col-sm-6 order-sm-2 order-lg-1 pt-100 pb-75" data-astro-cid-sckkx6r4> <div class="single-footer-widget academics" data-astro-cid-sckkx6r4> <h3 data-astro-cid-sckkx6r4>Academics</h3> <ul class="list-unstyled ps-0 mb-0" data-astro-cid-sckkx6r4> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/programs/1/?name=Undergraduate" data-astro-cid-sckkx6r4>Undergraduate</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/programs/2/?name=graduate" data-astro-cid-sckkx6r4>Graduate</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/programs/3/?name=Wmba" data-astro-cid-sckkx6r4>WMBA</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/programs/4/?name=M.phil / phd" data-astro-cid-sckkx6r4>M.Phil / P.hD</a> </li> </ul> </div> </div> <div class="col-lg-6 col-sm-12 order-sm-1 order-lg-2 pt-75 pb-75" style="text-align: center; background-color: var(--grey);" data-astro-cid-sckkx6r4> <div class="single-footer-widget about" data-astro-cid-sckkx6r4> <img${addAttribute(logo_data.data.value, "src")} alt="ju_IBA_logo" width="100" data-astro-cid-sckkx6r4> <h3 data-astro-cid-sckkx6r4>Institute of Business Administration</h3> <p data-astro-cid-sckkx6r4>Jahangirnagar University, Savar, Dhaka-1342, Bangladesh</p> <h6 data-astro-cid-sckkx6r4>Follow @</h6> <ul class="list-unstyled ps-0 mb-0 social-link" data-astro-cid-sckkx6r4> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="https://m.facebook.com/IBA.JU/" target="_blank" data-astro-cid-sckkx6r4> <i class="flaticon-facebook-app-symbol" data-astro-cid-sckkx6r4></i> </a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="https://youtube.com/" target="_blank" data-astro-cid-sckkx6r4> <i class="fab fa-youtube" data-astro-cid-sckkx6r4></i> </a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="https://www.linkedin.com/" target="_blank" data-astro-cid-sckkx6r4> <i class="fab fa-linkedin" data-astro-cid-sckkx6r4></i> </a> </li> <li class="d-inline-block" data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="https://www.instagram.com/" target="_blank" data-astro-cid-sckkx6r4> <i class="flaticon-instagram" data-astro-cid-sckkx6r4></i> </a> </li> </ul> </div> </div> <div class="col-lg-3 col-sm-6 col-md-6 order-sm-3 order-lg-3 pt-100 pb-75" style="text-align: right;" data-astro-cid-sckkx6r4> <div class="single-footer-widget quick" data-astro-cid-sckkx6r4> <h3 data-astro-cid-sckkx6r4>Quick Links</h3> <ul class="list-unstyled ps-0 mb-0" data-astro-cid-sckkx6r4> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/notices" data-astro-cid-sckkx6r4>Notices</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/admission" data-astro-cid-sckkx6r4>Admission</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/events" data-astro-cid-sckkx6r4>Events</a> </li> <li data-astro-cid-sckkx6r4> <a class="text-decoration-none" href="/contact-us" data-astro-cid-sckkx6r4>Contact Us</a> </li> </ul> </div> </div> </div> </div> </div> </div> </div> <div style="padding: 0.5rem; text-align: center; color: var(--blackColor); font-weight: 100;" data-astro-cid-sckkx6r4> <span class="d-block" data-astro-cid-sckkx6r4>Copyright © 2025 IBA-JU. Tech partner
<a href="https://campus365.net/" data-astro-cid-sckkx6r4><img${addAttribute(campus365Logo.src, "src")} alt="campus365Logo" width="50" data-astro-cid-sckkx6r4></a></span> </div> <!-- End Footer Area --> ${renderScript($$result, "E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro?astro&type=script&index=0&lang.ts")} ${renderScript($$result, "E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro?astro&type=script&index=1&lang.ts")} </body><!-- Start Footer Area --></html>`;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/layouts/Layout.astro", undefined);

export { $$Layout as $ };
